package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aTicketPeticion;

/**
 * Ab18a07s00DaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aTicketPeticionDaoImpl implements Ab18aTicketPeticionDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aTicketPeticion> rwMap = new RowMapper<Ab18aTicketPeticion>() {
		public Ab18aTicketPeticion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aTicketPeticion(resultSet.getInt("T07IDTICKET"),
					resultSet.getString("T07TICKET"),
					resultSet.getDate("T07FECHAPETICION"),
					resultSet.getInt("AB18A03S00T03IDAPLICACION"));
		}
	};

	private RowMapper<Ab18aTicketPeticion> rwMapPK = new RowMapper<Ab18aTicketPeticion>() {
		public Ab18aTicketPeticion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aTicketPeticion(resultSet.getInt("T07IDTICKET"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aTicketPeticion>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aTicketPeticion>>() {
		public JerarquiaDto<Ab18aTicketPeticion> mapRow(ResultSet resultSet,
				int rowNum) throws SQLException {

			Ab18aTicketPeticion ab18a07s00 = new Ab18aTicketPeticion(
					resultSet.getInt("T07IDTICKET"),
					resultSet.getString("T07TICKET"),
					resultSet.getDate("T07FECHAPETICION"),
					resultSet.getInt("T03IDAPLICACION"));

			JerarquiaDto<Ab18aTicketPeticion> jerarquia = new JerarquiaDto<Ab18aTicketPeticion>();
			jerarquia.setModel(ab18a07s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * @param secuencia
	 *            String
	 * @return String
	 * @throws Exception
	 *             the exception
	 */
	public int getNextSequenceValue(String secuencia) throws Exception {
		Integer sequenceValue = -1;
		try {
			String query = "SELECT " + secuencia + ".NEXTVAL FROM DUAL";
			sequenceValue = this.jdbcTemplate.queryForInt(query);
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}
		return sequenceValue;
	}

	/**
	 * Inserts a single row in the Ab18a07s00 table.
	 * 
	 * @param ticketPeticion
	 *            Ab18aTicketPeticion
	 * @return Ab18aTicketPeticion
	 * @throws Exception
	 *             the exception
	 */
	public Ab18aTicketPeticion add(Ab18aTicketPeticion ticketPeticion)
			throws Exception {

		try {
			ticketPeticion.setT07IdTicket(this
					.getNextSequenceValue("SQAB18A07"));
		} catch (Exception e) {
			throw new Exception(e.getMessage());
		}

		String query = "INSERT INTO AB18A07S00 (T07_ID_TICKET, T07_TICKET, T07_FECHA_PETICION, T03_ID_APLICACION) VALUES (?,?,?,?)";
		List<Object> params = new ArrayList<Object>();
		params.add(ticketPeticion.getT07IdTicket());
		params.add(ticketPeticion.getT07Ticket());
		params.add(ticketPeticion.getT07FechaPeticion());
		params.add(ticketPeticion.getT03IdAplicacion());
		this.jdbcTemplate.update(query, params.toArray());

		return ticketPeticion;
	}

	/**
	 * Updates a single row in the Ab18a07s00 table.
	 * 
	 * @param ticketPeticion
	 *            Ab18aTicketPeticion
	 * @return Ab18aTicketPeticion
	 */
	public Ab18aTicketPeticion update(Ab18aTicketPeticion ticketPeticion) {
		String query = "UPDATE AB18A07S00 SET T03_ID_APLICACION=?, T07_TICKET=?, T07_FECHA_PETICION=? WHERE T07_ID_TICKET=?";

		this.jdbcTemplate.update(query, ticketPeticion.getT03IdAplicacion(),
				ticketPeticion.getT07Ticket(),
				ticketPeticion.getT07FechaPeticion(),
				ticketPeticion.getT07IdTicket());
		return ticketPeticion;
	}

	/**
	 * Finds a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @return Ab18a07s00
	 */
	@Transactional(readOnly = true)
	public Ab18aTicketPeticion find(Ab18aTicketPeticion ab18a07s00) {
		String query = "SELECT t1.T07_ID_TICKET T07IDTICKET, t1.T07_TICKET T07TICKET, t1.T07_FECHA_PETICION T07FECHAPETICION, t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION, t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION, t2.T03_DESC_ES AB18A03S00T03DESCES, t2.T03_DESC_EU AB18A03S00T03DESCEU FROM AB18A07S00 t1 , AB18A03S00 t2  WHERE t1.T07_ID_TICKET = ? AND t1.T03_ID_APLICACION = t2.T03_ID_APLICACION";

		List<Ab18aTicketPeticion> ab18a07s00List = this.jdbcTemplate.query(
				query, this.rwMap, ab18a07s00.getT07IdTicket());
		return (Ab18aTicketPeticion) DataAccessUtils
				.uniqueResult(ab18a07s00List);
	}

	/**
	 * Removes a single row in the Ab18a07s00 table.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @return
	 */
	public void remove(Ab18aTicketPeticion ab18a07s00) {
		String query = "DELETE FROM AB18A07S00 WHERE T07_ID_TICKET=?";
		this.jdbcTemplate.update(query, ab18a07s00.getT07IdTicket());
	}

	/**
	 * Finds a list of rows in the Ab18a07s00 table.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18a07s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTicketPeticion> findAll(Ab18aTicketPeticion ab18a07s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		query.append("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a07s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTicketPeticion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a07s00 table using like.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18a07s00>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aTicketPeticion> findAllLike(
			Ab18aTicketPeticion ab18a07s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		query.append("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a07s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aTicketPeticion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a07s00 table.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aTicketPeticion ab18a07s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A07S00 t1 , AB18A03S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab18a07s00);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a07s00 table using like.
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aTicketPeticion ab18a07s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A07S00 t1 ,AB18A03S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a07s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a07s00 selected for rup_table
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a07s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTicketPeticion>> reorderSelection(
			Ab18aTicketPeticion ab18a07s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		// FROM
		query.append("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab18a07s00, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aTicketPeticion.class,
				filterParamList, "T07_ID_TICKET");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aTicketPeticion>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18a07s00
	 * @param searchParams
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18a07s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTicketPeticion>> search(
			Ab18aTicketPeticion filterParams, Ab18aTicketPeticion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		// FROM
		query.append("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T03_ID_APLICACION= t2.T03_ID_APLICACION(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aTicketPeticion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"T07_ID_TICKET");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aTicketPeticion>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aTicketPeticion filterab18a07s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		// FROM
		query.append("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a07s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						Ab18aTicketPeticion.class, query, params,
						"T07_ID_TICKET");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a07s00 table.
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18a07s00>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aTicketPeticion>> findAllLikeJerarquia(
			Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T07_ID_TICKET T07IDTICKET,t1.T07_TICKET T07TICKET,t1.T07_FECHA_PETICION T07FECHAPETICION,t2.T03_ID_APLICACION AB18A03S00T03IDAPLICACION,t2.T03_MODO_RECEPCION AB18A03S00T03MODORECEPCION,t2.T03_DESC_ES AB18A03S00T03DESCES,t2.T03_DESC_EU AB18A03S00T03DESCEU ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A07S00");
		from.add("AB18A03S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a07s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T07_ID_TICKET", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A07S00");
		from.add("AB18A03S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a07s00, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T07_ID_TICKET", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18a07s00
	 *            Ab18a07s00
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18a07s00>>
	 */
	@Override
	public List<TableRowDto<Ab18aTicketPeticion>> findAllChild(
			Ab18aTicketPeticion filterAb18a07s00,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A07S00 t1 ,AB18A03S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A07S00");
		from.add("AB18A03S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAb18a07s00, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T07_ID_TICKET", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aTicketPeticion>(this.rwMapPK,
						"T07_ID_TICKET"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a07s00 entity
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(Ab18aTicketPeticion ab18a07s00) {

		StringBuilder where = new StringBuilder(
				Ab18aTicketPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a07s00 != null && ab18a07s00.getT07IdTicket() != null) {
			where.append(" AND t1.T07_ID_TICKET = ?");
			params.add(ab18a07s00.getT07IdTicket());
		}

		if (ab18a07s00 != null && ab18a07s00.getT07Ticket() != null) {
			where.append(" AND t1.T07_TICKET = ?");
			params.add(ab18a07s00.getT07Ticket());
		}
		if (ab18a07s00 != null && ab18a07s00.getT07FechaPeticion() != null) {
			where.append(" AND t1.T07_FECHA_PETICION = ?");
			params.add(ab18a07s00.getT07FechaPeticion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a07s00 entity
	 * 
	 * @param ab18a07s00
	 *            Ab18a07s00 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(Ab18aTicketPeticion ab18a07s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aTicketPeticionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab18a07s00 != null && ab18a07s00.getT07IdTicket() != null) {
			where.append(" AND t1.T07_ID_TICKET = ?");
			params.add(ab18a07s00.getT07IdTicket());
		}

		if (ab18a07s00 != null && ab18a07s00.getT07Ticket() != null) {
			where.append(" AND UPPER(t1.T07_TICKET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab18a07s00.getT07Ticket().toUpperCase() + "%");
			} else {
				params.add("%" + ab18a07s00.getT07Ticket().toUpperCase() + "%");
			}
			where.append(" AND t1.T07_TICKET IS NOT NULL");
		}
		if (ab18a07s00 != null && ab18a07s00.getT07FechaPeticion() != null) {
			where.append(" AND t1.T07_FECHA_PETICION = ?");
			params.add(ab18a07s00.getT07FechaPeticion());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
